using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class FOLLOWUP_FORM_RESPONSEDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public FOLLOWUP_FORM_RESPONSEDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public FOLLOWUP_FORM_RESPONSE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FOLLOWUP_FORM_RESPONSE_ID)
		{
			FOLLOWUP_FORM_RESPONSE objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_FOLLOWUP_FORM_RESPONSE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, FOLLOWUP_FORM_RESPONSE_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<FOLLOWUP_FORM_RESPONSE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<FOLLOWUP_FORM_RESPONSE> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_FOLLOWUP_FORM_RESPONSE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<FOLLOWUP_FORM_RESPONSE> GetItemsByRegistrant(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REGISTRANT_ID)
        {
            List<FOLLOWUP_FORM_RESPONSE> objReturn = null;

            try
            {
                using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_FOLLOWUP_FORM_RESPONSE_getitemsByRegistrant(CURRENT_USER, CURRENT_REGISTRY_ID, REGISTRANT_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, FOLLOWUP_FORM_RESPONSE objSave)
		{
			Int32? objReturn = objSave.FOLLOWUP_FORM_RESPONSE_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_FOLLOWUP_FORM_RESPONSE_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.COMPLETED_DATE, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.REGISTRANT_ID, objSave.STD_FORM_ID, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FOLLOWUP_FORM_RESPONSE_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_FOLLOWUP_FORM_RESPONSE_delete(CURRENT_USER, CURRENT_REGISTRY_ID, FOLLOWUP_FORM_RESPONSE_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
